/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building;

import knightminer.inspirations.Inspirations;
import knightminer.inspirations.building.InspirationsBuilding;
import knightminer.inspirations.building.block.BlockBookshelf;
import knightminer.inspirations.building.block.BlockEnlightenedBush;
import knightminer.inspirations.building.block.BlockFlower;
import knightminer.inspirations.building.block.BlockRope;
import knightminer.inspirations.building.client.BookshelfModel;
import knightminer.inspirations.building.tileentity.TileBookshelf;
import knightminer.inspirations.common.ClientProxy;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.library.client.BlockItemStateMapper;
import knightminer.inspirations.library.client.ClientUtil;
import knightminer.inspirations.library.client.PropertyStateMapper;
import knightminer.inspirations.library.util.TextureBlockUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BuildingClientProxy
extends ClientProxy {
    public static final Minecraft mc = Minecraft.func_71410_x();

    @Override
    public void preInit() {
        super.preInit();
        if (Config.enableBookshelf) {
            IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
            if (manager instanceof IReloadableResourceManager) {
                ((IReloadableResourceManager)manager).func_110542_a(l -> BookshelfModel.BOOK_CACHE.invalidateAll());
            } else {
                Inspirations.log.error("Failed to register resource reload listener, expected instance of IReloadableResourceManager but got {}", manager.getClass());
            }
        }
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        BuildingClientProxy.setModelStateMapper(InspirationsBuilding.glassDoor, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a());
        BuildingClientProxy.setModelStateMapper(InspirationsBuilding.flower, (IStateMapper)new BlockItemStateMapper(new IProperty[0]));
        BuildingClientProxy.setModelStateMapper((Block)InspirationsBuilding.rope, (IStateMapper)new PropertyStateMapper(BlockRope.TYPE, new IProperty[0]));
        BuildingClientProxy.registerItemMetaDynamic(InspirationsBuilding.books);
        BuildingClientProxy.registerItemModel(InspirationsBuilding.glassDoorItem);
        BuildingClientProxy.registerItemModel(InspirationsBuilding.glassTrapdoor);
        this.registerRopeModels((Block)InspirationsBuilding.rope);
        BuildingClientProxy.registerItemBlockMeta(InspirationsBuilding.mulch);
        BuildingClientProxy.registerItemBlockMeta((Block)InspirationsBuilding.path);
        BuildingClientProxy.registerItemBlockMeta((Block)InspirationsBuilding.enlightenedBush);
        this.registerFlowerModels(InspirationsBuilding.flower);
        this.registerBookshelfModels(InspirationsBuilding.bookshelf);
    }

    private void registerBookshelfModels(Block bookshelf) {
        if (bookshelf != null) {
            for (BlockBookshelf.BookshelfType type : BlockBookshelf.BookshelfType.values()) {
                BuildingClientProxy.registerItemModel(bookshelf, type.getMeta(), "facing=south,type=" + type.func_176610_l());
            }
        }
    }

    private void registerRopeModels(Block rope) {
        if (rope != null) {
            for (BlockRope.RopeType type : BlockRope.RopeType.values()) {
                BuildingClientProxy.registerItemModel(rope, type.getMeta(), type.func_176610_l());
            }
        }
    }

    private void registerFlowerModels(Block flower) {
        if (flower != null) {
            for (BlockFlower.FlowerType type : BlockFlower.FlowerType.values()) {
                BuildingClientProxy.registerItemModel(flower, type.getMeta(), "block=false,type=" + type.func_176610_l());
            }
        }
    }

    @SubscribeEvent
    public void registerBlockColors(ColorHandlerEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        BuildingClientProxy.registerBlockColors(blockColors, (state, world, pos, tintIndex) -> {
            ItemStack stack;
            TileEntity te;
            if (state.func_177229_b(BlockBookshelf.TYPE) == BlockBookshelf.BookshelfType.NORMAL && tintIndex > 0 && tintIndex <= 14 && (te = world.func_175625_s(pos)) instanceof TileBookshelf && !(stack = ((TileBookshelf)te).func_70301_a(tintIndex - 1)).func_190926_b()) {
                int color = ClientUtil.getStackColor(stack);
                int itemColors = mc.getItemColors().func_186728_a(stack, 0);
                if (itemColors > -1) {
                    color = Util.combineColors(color, itemColors, 3);
                }
                return color;
            }
            return -1;
        }, InspirationsBuilding.bookshelf);
        BuildingClientProxy.registerBlockColors(blockColors, (state, world, pos, tintIndex) -> {
            if (state.func_177229_b(BlockRope.TYPE) == BlockRope.RopeType.VINE) {
                if (world != null && pos != null) {
                    return BiomeColorHelper.func_180287_b((IBlockAccess)world, (BlockPos)pos);
                }
                return ColorizerFoliage.func_77468_c();
            }
            return -1;
        }, new Block[]{InspirationsBuilding.rope});
        BuildingClientProxy.registerBlockColors(blockColors, (state, world, pos, tintIndex) -> {
            if (tintIndex != 0) {
                return -1;
            }
            int color = ((BlockEnlightenedBush.LightsType)((Object)((Object)state.func_177229_b(BlockEnlightenedBush.LIGHTS)))).getColor();
            if (color > -1) {
                return color;
            }
            TileEntity te = world.func_175625_s(pos);
            if (te != null) {
                ItemStack stack = new ItemStack(TextureBlockUtil.getTextureBlock(te));
                return ClientUtil.getStackBlockColorsSafe(stack, world, pos, 0);
            }
            return ColorizerFoliage.func_77468_c();
        }, new Block[]{InspirationsBuilding.enlightenedBush});
    }

    @SubscribeEvent
    public void registerItemColors(ColorHandlerEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        BuildingClientProxy.registerItemColors(itemColors, (stack, tintIndex) -> {
            if (BlockBookshelf.BookshelfType.fromMeta(stack.func_77960_j()) == BlockBookshelf.BookshelfType.NORMAL && tintIndex > 0 && tintIndex <= 14) {
                return 6638359;
            }
            return -1;
        }, InspirationsBuilding.bookshelf);
        BuildingClientProxy.registerItemColors(itemColors, (stack, tintIndex) -> {
            int meta = stack.func_77952_i();
            if (tintIndex == 0 && meta < 16) {
                return EnumDyeColor.func_176764_b((int)meta).func_193350_e();
            }
            return -1;
        }, new Item[]{InspirationsBuilding.books});
        BuildingClientProxy.registerItemColors(itemColors, (stack, tintIndex) -> {
            if (tintIndex != 0) {
                return -1;
            }
            int color = BlockEnlightenedBush.LightsType.fromMeta(stack.func_77960_j()).getColor();
            if (color > -1) {
                return color;
            }
            ItemStack textureStack = TextureBlockUtil.getStackTexture(stack);
            if (!textureStack.func_190926_b() && textureStack.func_77973_b() != Item.func_150898_a((Block)InspirationsBuilding.enlightenedBush)) {
                return itemColors.func_186728_a(textureStack, 0);
            }
            return ColorizerFoliage.func_77468_c();
        }, new Block[]{InspirationsBuilding.enlightenedBush});
        BuildingClientProxy.registerItemColors(itemColors, (stack, tintIndex) -> ClientUtil.getStackBlockColors(stack, null, null, tintIndex), new Block[]{InspirationsBuilding.rope});
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        if (InspirationsBuilding.bookshelf != null) {
            ResourceLocation bookshelfLoc = InspirationsBuilding.bookshelf.getRegistryName();
            for (Enum enum_ : BlockBookshelf.BookshelfType.values()) {
                for (EnumFacing facing : EnumFacing.field_176754_o) {
                    BuildingClientProxy.replaceBookshelfModel(event, new ModelResourceLocation(bookshelfLoc, String.format("facing=%s,type=%s", facing.func_176610_l(), ((BlockBookshelf.BookshelfType)enum_).func_176610_l())));
                }
            }
        }
        if (InspirationsBuilding.enlightenedBush != null) {
            ResourceLocation location = InspirationsBuilding.enlightenedBush.getRegistryName();
            for (Enum enum_ : BlockEnlightenedBush.LightsType.values()) {
                BuildingClientProxy.replaceTexturedModel(event, new ModelResourceLocation(location, String.format("lights=%s", ((BlockEnlightenedBush.LightsType)enum_).func_176610_l())), "leaves", true);
            }
        }
    }

    private static void replaceBookshelfModel(ModelBakeEvent event, ModelResourceLocation location) {
        IModel model = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)location, (String)("Error loading model for " + location));
        IBakedModel standard = (IBakedModel)event.getModelRegistry().func_82594_a((Object)location);
        BookshelfModel finalModel = new BookshelfModel(standard, model, DefaultVertexFormats.field_176600_a);
        event.getModelRegistry().func_82595_a((Object)location, (Object)finalModel);
    }
}

